# Likenorm_random.R
# Plot likelihood for normal data vs. mu, sig2

# Load necessary libraries
library(ggplot2)

# Define likelihood function
likefn <- function(musig2,y){
mu <- musig2[1]
sig2 <- musig2[2]
sig <- sqrt(sig2)
return(prod(dnorm(y,mu,sig)))
}

# Generate n random normal observations
n <- 10
mu_true <- 5
sig2_true <- 0.25
sig_true <- sqrt(sig2_true)
y <- rnorm(n,mu_true,sig_true)

# Minimum maximum, and step values of mu
mumin <- 4
mumax <- 6
mustep <- 0.01

# Find mu values for the plot
mu <- seq(mumin,mumax,mustep)

# Minimum, maximum, and step values of sig2
sig2min <- 0.05
sig2max <- 0.5
sig2step <- 0.01

# Find sig2 values for the plot
sig2 <- seq(sig2min,sig2max,sig2step)

# Generate matrix (grid) of mu and sig2 values
muvec <- rep(mu,length(sig2))
sig2vec <- rep(sig2,each=length(mu))
musig2 <- cbind(muvec,sig2vec)

# Find likelihood as a function of mu, sig2
likelihood <- apply(musig2,1,likefn,y)

# Make data frame for ggplot2
likedata <- as.data.frame(cbind(muvec,sig2vec,likelihood))

# Print y data
y

# Print likelihood data
likedata

# Plot the values
ggplot(likedata,aes(muvec,sig2vec,z=likelihood))+geom_contour()+
ggtitle("Normal likelihood function")

